<?php

require("../../../database/dbConection.php");
$dataHoje   = date("Y-m-d");

# -- LIMPAR TABELA DE DADOS TEMPORÁRIOS DE VAGAS RESTAURADAS --#
$stmLimparVagasRestauradas  = $rsConexao->prepare("DELETE FROM reg_tb_vagasrestauradas");
$stmLimparVagasRestauradas  -> execute();
$stmLimparVagasRestauradas  = $rsConexao->prepare("ALTER TABLE reg_tb_vagasrestauradas AUTO_INCREMENT=1");
$stmLimparVagasRestauradas  -> execute();

# -- BUSCAR TODOS OS AGENDAMENTOS COM PRAZO DE RETIDADA VENCIDOS -- #
$stmAgendamentos  = "SELECT *,
reg_tb_agenda.codigoestabelecimento_cnes,
reg_tb_agenda.codigoprofissional_cnes
FROM reg_tb_agendamentos 
INNER JOIN reg_tb_agenda ON (reg_tb_agenda.id_agenda=reg_tb_agendamentos.id_agenda)
WHERE (id_agenda_sub IS NOT NULL AND id_agenda_sub!='')
AND ((status_agendamento='A' AND date_format(dataprazo_retirada,'%Y-%m-%d')<'$dataHoje') OR (status_agendamento='X'))
ORDER BY tipo_vagaocupada";

$stmAgendamentos  = $rsConexao->prepare($stmAgendamentos);
$stmAgendamentos->execute();

if ($stmAgendamentos->rowCount() > 0) {
  
  $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsAgendamentos as $fieldAgendamento) {
    $idAgendamento        = $fieldAgendamento['id_agendamento'];
    $numeroProtocolo      = $fieldAgendamento['protocolo_agendamento'];
    $idAgenda             = $fieldAgendamento['id_agenda'];
    $idAgendaSub          = $fieldAgendamento['id_agenda_sub'];
    $idSolicitacao        = $fieldAgendamento['id_solicitacao'];
    $tipoVagaOcupada      = $fieldAgendamento['tipo_vagaocupada'];
    $prazoRetirada        = $fieldAgendamento['dataprazo_retirada'];
    $origemAgendamento    = $fieldAgendamento['origem_agendamento'];
    $idGrupoProcedimento  = $fieldAgendamento['id_grupo_procedimento'];
    $idProcedimento       = $fieldAgendamento['id_procedimento']=="" ? 'null' : $fieldAgendamento['id_procedimento'];
    $codigoUnidade        = $fieldAgendamento['codigoestabelecimento_cnes'];
    $codigoProfissional   = $fieldAgendamento['codigoprofissional_cnes'];
    $dataAtendimento      = $fieldAgendamento['data_atendimento'];
    
    # -- cancelar agendamento -- #
    $sqlCancelarAgendamento = "UPDATE reg_tb_agendamentos 
    SET status_agendamento='C',
    informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
    datahora_cancelamento=NOW()
    WHERE (id_agendamento='$idAgendamento')";
    $stmCancelarAgendamento = $rsConexao->prepare($sqlCancelarAgendamento);
    $stmCancelarAgendamento->execute();
    $stmCancelarAgendamento->closeCursor();

    # -- cancelar solicitacoes -- #
    if ($idSolicitacao != "") {
      $sqlCancelarSolicitacao = "UPDATE reg_tb_solicitacoes 
      SET id_statussolicitacao='5',
      informacoes_cancelamento='CANCELAMENTO AUTOMÁTICO',
      datahora_cancelamento=NOW()    
      WHERE (id_solicitacao='$idSolicitacao')";
      $stmCancelarSolicitacao = $rsConexao->prepare($sqlCancelarSolicitacao);
      $stmCancelarSolicitacao->execute();
      $stmCancelarSolicitacao->closeCursor();
    }

    # --- pegar campo do tipo de vaga ocupada do sistema ---#
    if ($idAgendaSub != "") {
      if (mb_strtoupper($tipoVagaOcupada) == "PVEZ") {
        $campoVagaAgenda  = "quantidadegendada_pvez";
      } else if (mb_strtoupper($tipoVagaOcupada) == "RETORNO") {
        $campoVagaAgenda  = "quantidadeagendada_retorno";
      } else {
        $campoVagaAgenda  = "quantidadeagendada_reserva";
      }
      # -- devolver vaga à agenda -- #      
      $stmTotalOcupado  = $rsConexao->prepare("SELECT $campoVagaAgenda FROM reg_tb_agenda_sub WHERE id_agenda_sub='$idAgendaSub'");
      $stmTotalOcupado->execute();
      $rsTotalOcupado   = $stmTotalOcupado->fetch(PDO::FETCH_OBJ);
      if (mb_strtoupper($tipoVagaOcupada) == "PVEZ") {
        $totalOcupado = $rsTotalOcupado->quantidadegendada_pvez != "" ? $rsTotalOcupado->quantidadegendada_pvez : 0;
      } else if (mb_strtoupper($tipoVagaOcupada) == "RETORNO") {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_retorno != "" ? $rsTotalOcupado->quantidadeagendada_retorno : 0;
      } else {
        $totalOcupado = $rsTotalOcupado->quantidadeagendada_reserva != "" ? $rsTotalOcupado->quantidadeagendada_reserva : 0;
      }
      $novoTotalOcupado = $totalOcupado != 0 ? $totalOcupado - 1 : $totalOcupado;
      $stmDevolveVagaAgenda = $rsConexao->prepare("UPDATE reg_tb_agenda_sub SET $campoVagaAgenda='$novoTotalOcupado' WHERE id_agenda_sub='$idAgendaSub'");
      $stmDevolveVagaAgenda->execute();
      $stmDevolveVagaAgenda->closeCursor();
    }

  # -- adicionar registro temporário de vagas restauradas para envio de notificação -- #
    $sqlGravarVagasrestauradas = "INSERT INTO reg_tb_vagasrestauradas(
      tipo_vaga,
      id_grupoprocedimento,
      id_procedimento,
      codigoestabelecimento_cnes,
      codigoprofissional_cnes,
      data_atendimento
    )VALUES(
      '$tipoVagaOcupada',
      '$idGrupoProcedimento',
      $idProcedimento,
      '$codigoUnidade',
      '$codigoProfissional',
      '$dataAtendimento'
    )";
    $stmGravarVagasrestauradas  =  $rsConexao->prepare($sqlGravarVagasrestauradas);
    $stmGravarVagasrestauradas  -> execute();
    $stmGravarVagasrestauradas  -> closeCursor();
  }
}

# -- CANCELAR TODAS AS SOLICITAÇÕES COM STATUS CANCELAR -- #
$stmSolicitacao = $rsConexao->prepare("UPDATE reg_tb_solicitacoes SET id_statussolicitacao='5' WHERE (id_statussolicitacao='4')");
$stmSolicitacao ->execute();
$stmSolicitacao ->closeCursor();

?>